/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.signal.storageservice.CassandraStorageService;
import org.signal.storageservice.auth.User;
import org.signal.storageservice.storage.StorageItemsTable;
import org.signal.storageservice.storage.StorageManifestsTable;
import org.signal.storageservice.storage.protos.contacts.StorageItem;
import org.signal.storageservice.storage.protos.contacts.StorageManifest;

public class StorageManager {
    private final StorageManifestsTable manifestsTable = new StorageManifestsTable();
    private final StorageItemsTable itemsTable = new StorageItemsTable();

    public CompletableFuture<Optional<StorageManifest>> set(User user, StorageManifest manifest, List<StorageItem> inserts, List<ByteString> deletes) {
        return this.manifestsTable.set(user, manifest).thenCompose(updated -> {
            if (updated.booleanValue()) {
                return this.itemsTable.set(user, inserts, deletes).thenApply(nothing -> Optional.empty());
            }
            return this.getManifest(user).thenApply(retrieved -> Optional.of((StorageManifest)retrieved.orElseThrow()));
        });
    }

    public CompletableFuture<Optional<StorageManifest>> getManifest(User user) {
        return this.manifestsTable.get(user);
    }

    public CompletableFuture<Optional<StorageManifest>> getManifestIfNotVersion(User user, long version) {
        return this.manifestsTable.getIfNotVersion(user, version);
    }

    public CompletableFuture<List<StorageItem>> getItems(User user, List<ByteString> keys) {
        return CassandraStorageService.getStorageItem(user, keys);
    }

    public CompletableFuture<Void> clearItems(User user) {
        return CassandraStorageService.clearStorage(user);
    }
}

