/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.signal.storageservice.CassandraStorageService;
import org.signal.storageservice.storage.protos.groups.Group;
import org.signal.storageservice.storage.protos.groups.GroupChange;
import org.signal.storageservice.storage.protos.groups.GroupChanges;
import org.signal.storageservice.util.Conversions;

public class GroupLogTable {
    public CompletableFuture<Boolean> append(ByteString groupId, int version, GroupChange groupChange, Group group) {
        return CassandraStorageService.createGrpLog(this.getRowId(groupId, version), version, groupChange, group, groupId);
    }

    public CompletableFuture<List<GroupChanges.GroupChangeState>> getRecordsFromVersion(ByteString groupId, int fromVersionInclusive, int toVersionExclusive) {
        return CassandraStorageService.getGroupRecordFromVersion(groupId, fromVersionInclusive);
    }

    private ByteString getRowId(ByteString groupId, int version) {
        return groupId.concat(ByteString.copyFromUtf8((String)"#")).concat(ByteString.copyFrom((byte[])Conversions.intToByteArray(version)));
    }
}

