/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.metrics;

import java.io.IOException;
import org.signal.storageservice.metrics.NetworkGauge;
import org.signal.storageservice.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkSentGauge
extends NetworkGauge {
    private final Logger logger = LoggerFactory.getLogger(NetworkSentGauge.class);
    private long lastTimestamp;
    private long lastSent;

    public NetworkSentGauge() {
        try {
            this.lastTimestamp = System.currentTimeMillis();
            this.lastSent = this.getSentReceived().first();
        }
        catch (IOException e) {
            this.logger.warn(NetworkSentGauge.class.getSimpleName(), (Throwable)e);
        }
    }

    public Double getValue() {
        try {
            long timestamp = System.currentTimeMillis();
            Pair<Long, Long> sentAndReceived = this.getSentReceived();
            double bytesTransmitted = sentAndReceived.first() - this.lastSent;
            double secondsElapsed = (timestamp - this.lastTimestamp) / 1000L;
            double result = bytesTransmitted / secondsElapsed;
            this.lastSent = sentAndReceived.first();
            this.lastTimestamp = timestamp;
            return result;
        }
        catch (IOException e) {
            this.logger.warn("NetworkSentGauge", (Throwable)e);
            return -1.0;
        }
    }
}

