/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.controllers;

import com.codahale.metrics.annotation.Timed;
import com.google.protobuf.ByteString;
import io.dropwizard.auth.Auth;
import io.dropwizard.util.Strings;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.signal.storageservice.auth.ExternalGroupCredentialGenerator;
import org.signal.storageservice.auth.GroupUser;
import org.signal.storageservice.configuration.GroupConfiguration;
import org.signal.storageservice.groups.GroupAuth;
import org.signal.storageservice.groups.GroupChangeApplicator;
import org.signal.storageservice.groups.GroupValidator;
import org.signal.storageservice.providers.NoUnknownFields;
import org.signal.storageservice.s3.PolicySigner;
import org.signal.storageservice.s3.PostPolicyGenerator;
import org.signal.storageservice.storage.GroupsManager;
import org.signal.storageservice.storage.protos.groups.AccessControl;
import org.signal.storageservice.storage.protos.groups.AvatarUploadAttributes;
import org.signal.storageservice.storage.protos.groups.ExternalGroupCredential;
import org.signal.storageservice.storage.protos.groups.Group;
import org.signal.storageservice.storage.protos.groups.GroupChange;
import org.signal.storageservice.storage.protos.groups.GroupChanges;
import org.signal.storageservice.storage.protos.groups.GroupJoinInfo;
import org.signal.storageservice.storage.protos.groups.Member;
import org.signal.storageservice.storage.protos.groups.MemberPendingAdminApproval;
import org.signal.storageservice.storage.protos.groups.MemberPendingProfileKey;
import org.signal.storageservice.util.CollectionUtil;
import org.signal.storageservice.util.Pair;
import org.signal.zkgroup.NotarySignature;
import org.signal.zkgroup.ServerSecretParams;
import org.signal.zkgroup.profiles.ServerZkProfileOperations;

@Path(value="/v1/groups")
public class GroupsController {
    private static final int LOG_VERSION_LIMIT = 64;
    private static final int INVITE_LINKS_CHANGE_EPOCH = 1;
    private final GroupsManager groupsManager;
    private final ServerSecretParams serverSecretParams;
    private final GroupValidator groupValidator;
    private final GroupChangeApplicator groupChangeApplicator;
    private final PolicySigner policySigner;
    private final PostPolicyGenerator policyGenerator;
    private final ExternalGroupCredentialGenerator externalGroupCredentialGenerator;

    public GroupsController(GroupsManager groupsManager, ServerSecretParams serverSecretParams, PolicySigner policySigner, PostPolicyGenerator policyGenerator, GroupConfiguration groupConfiguration, ExternalGroupCredentialGenerator externalGroupCredentialGenerator) {
        this.groupsManager = groupsManager;
        this.serverSecretParams = serverSecretParams;
        this.groupValidator = new GroupValidator(new ServerZkProfileOperations(serverSecretParams), groupConfiguration);
        this.groupChangeApplicator = new GroupChangeApplicator(this.groupValidator);
        this.policySigner = policySigner;
        this.policyGenerator = policyGenerator;
        this.externalGroupCredentialGenerator = externalGroupCredentialGenerator;
    }

    @Timed
    @GET
    @Produces(value={"application/x-protobuf"})
    public CompletableFuture<Response> getGroup(@Auth GroupUser user) {
        return this.groupsManager.getGroup(user.getGroupId()).thenApply(group -> {
            if (group.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (GroupAuth.isMember(user, (Group)group.get()) || GroupAuth.isMemberPendingProfileKey(user, (Group)group.get())) {
                return Response.ok(group.get()).build();
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        });
    }

    @Timed
    @GET
    @Produces(value={"application/x-protobuf"})
    @Path(value="/join/{inviteLinkPassword: [^/]*}")
    public CompletableFuture<Response> getGroupJoinInfo(@Auth GroupUser user, @PathParam(value="inviteLinkPassword") String inviteLinkPasswordString) {
        byte[] inviteLinkPassword = Strings.isNullOrEmpty((String)inviteLinkPasswordString) ? null : Base64.decodeBase64((String)inviteLinkPasswordString);
        return this.groupsManager.getGroup(user.getGroupId()).thenApply(group -> {
            if (group.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            AccessControl.AccessRequired accessRequired = ((Group)group.get()).getAccessControl().getAddFromInviteLink();
            boolean pendingAdminApproval = GroupAuth.isMemberPendingAdminApproval(user, (Group)group.get());
            if (!pendingAdminApproval) {
                if (!MessageDigest.isEqual(inviteLinkPassword, ((Group)group.get()).getInviteLinkPassword().toByteArray())) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
                if (accessRequired == AccessControl.AccessRequired.UNSATISFIABLE || accessRequired == AccessControl.AccessRequired.UNKNOWN) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
            }
            GroupJoinInfo.Builder groupJoinInfoBuilder = GroupJoinInfo.newBuilder();
            groupJoinInfoBuilder.setPublicKey(((Group)group.get()).getPublicKey());
            groupJoinInfoBuilder.setTitle(((Group)group.get()).getTitle());
            groupJoinInfoBuilder.setAvatar(((Group)group.get()).getAvatar());
            groupJoinInfoBuilder.setMemberCount(((Group)group.get()).getMembersCount());
            groupJoinInfoBuilder.setAddFromInviteLink(accessRequired);
            groupJoinInfoBuilder.setVersion(((Group)group.get()).getVersion());
            groupJoinInfoBuilder.setPendingAdminApproval(pendingAdminApproval);
            return Response.ok((Object)groupJoinInfoBuilder.build()).build();
        });
    }

    @Timed
    @GET
    @Produces(value={"application/x-protobuf"})
    @Path(value="/logs/{fromVersion}")
    public CompletableFuture<Response> getGroupLogs(@Auth GroupUser user, @PathParam(value="fromVersion") int fromVersion) {
        return this.groupsManager.getGroup(user.getGroupId()).thenCompose(group -> {
            if (group.isEmpty()) {
                return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            }
            Optional<Member> member = GroupAuth.getMember(user, (Group)group.get());
            if (member.isEmpty()) {
                return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            }
            if (member.get().getJoinedAtVersion() > fromVersion) {
                return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            }
            int latestGroupVersion = ((Group)group.get()).getVersion();
            if (latestGroupVersion + 1 <= fromVersion) {
                return CompletableFuture.completedFuture(Response.ok((Object)GroupChanges.newBuilder().build()).build());
            }
            System.out.println("get change records");
            if (latestGroupVersion + 1 - fromVersion > 64) {
                return this.groupsManager.getChangeRecords(user.getGroupId(), (Group)group.get(), fromVersion, fromVersion + 64).thenApply(records -> Response.status((int)206).header("Content-Range", (Object)String.format(Locale.US, "versions %d-%d/%d", fromVersion, fromVersion + 64 - 1, latestGroupVersion)).entity((Object)GroupChanges.newBuilder().addAllGroupChanges((Iterable<? extends GroupChanges.GroupChangeState>)records).build()).build());
            }
            return this.groupsManager.getChangeRecords(user.getGroupId(), (Group)group.get(), fromVersion, latestGroupVersion + 1).thenApply(records -> Response.ok((Object)GroupChanges.newBuilder().addAllGroupChanges((Iterable<? extends GroupChanges.GroupChangeState>)records).build()).build());
        });
    }

    @Timed
    @GET
    @Produces(value={"application/x-protobuf"})
    @Path(value="/avatar/form")
    public AvatarUploadAttributes getAvatarUploadForm(@Auth GroupUser user) {
        byte[] object = new byte[16];
        new SecureRandom().nextBytes(object);
        String objectName = "groups/" + Base64.encodeBase64URLSafeString((byte[])user.getGroupId().toByteArray()) + "/" + Base64.encodeBase64URLSafeString((byte[])object);
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        Pair<String, String> policy = this.policyGenerator.createFor(now, objectName, 0x300000);
        String signature = this.policySigner.getSignature(now, policy.second());
        return AvatarUploadAttributes.newBuilder().setKey(objectName).setCredential(policy.first()).setAcl("private").setAlgorithm("AWS4-HMAC-SHA256").setDate(now.format(PostPolicyGenerator.AWS_DATE_TIME)).setPolicy(policy.second()).setSignature(signature).build();
    }

    @Timed
    @PUT
    @Produces(value={"application/x-protobuf"})
    @Consumes(value={"application/x-protobuf"})
    public CompletableFuture<Response> createGroup(@Auth GroupUser user, @NoUnknownFields Group group) {
        Stream<ByteString> membersPendingProfileKeyUserIds;
        System.out.println("Creating  a group");
        if (group.getVersion() != 0) {
            return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        if (group.getPublicKey() == null || group.getPublicKey().isEmpty()) {
            return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        if (group.getTitle() == null || group.getTitle().isEmpty()) {
            return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        if (group.getAccessControl().getAttributes() == AccessControl.AccessRequired.UNKNOWN || group.getAccessControl().getAttributes() == AccessControl.AccessRequired.UNRECOGNIZED || group.getAccessControl().getMembers() == AccessControl.AccessRequired.UNKNOWN || group.getAccessControl().getMembers() == AccessControl.AccessRequired.UNRECOGNIZED) {
            return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        if (!MessageDigest.isEqual(user.getGroupPublicKey().serialize(), group.getPublicKey().toByteArray())) {
            return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
        }
        if (!this.groupValidator.isValidAvatarUrl(group.getAvatar(), user.getGroupId())) {
            return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        LinkedList<Member> validatedMembers = new LinkedList<Member>();
        LinkedList<MemberPendingProfileKey> validatedMemberPendingProfileKeys = new LinkedList<MemberPendingProfileKey>();
        for (Member member : group.getMembersList()) {
            validatedMembers.add(this.groupValidator.validateMember(group, member));
        }
        Optional<Member> source = GroupAuth.getMember(user, group = group.toBuilder().clearMembers().addAllMembers(validatedMembers).build());
        if (source.isEmpty() || source.get().getRole() != Member.Role.ADMINISTRATOR) {
            return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        for (MemberPendingProfileKey memberPendingProfileKey2 : group.getMembersPendingProfileKeyList()) {
            validatedMemberPendingProfileKeys.add(this.groupValidator.validateMemberPendingProfileKey(source.get(), group, memberPendingProfileKey2));
        }
        Stream<ByteString> stream = (group = group.toBuilder().clearMembersPendingProfileKey().addAllMembersPendingProfileKey(validatedMemberPendingProfileKeys).build()).getMembersList().stream().map(Member::getUserId);
        if (CollectionUtil.containsDuplicates(Stream.concat(stream, membersPendingProfileKeyUserIds = group.getMembersPendingProfileKeyList().stream().map(memberPendingProfileKey -> memberPendingProfileKey.getMember().getUserId())).collect(Collectors.toList()))) {
            return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        if (group.getMembersPendingAdminApprovalCount() > 0) {
            throw new BadRequestException("cannot create a group with already pending members");
        }
        Group validatedGroup = group;
        GroupChange initialGroupChange = GroupChange.newBuilder().setActions(GroupChange.Actions.newBuilder().setVersion(0).setSourceUuid(source.get().getUserId()).build().toByteString()).build();
        this.groupValidator.validateFinalGroupState(validatedGroup);
        return ((CompletableFuture)this.groupsManager.createGroup(user.getGroupId(), validatedGroup).thenCompose(created -> {
            if (!created.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            return this.groupsManager.appendChangeRecord(user.getGroupId(), 0, initialGroupChange, validatedGroup);
        })).thenApply(result -> {
            if (result.booleanValue()) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        });
    }

    @Timed
    @PATCH
    @Produces(value={"application/x-protobuf"})
    @Consumes(value={"application/x-protobuf"})
    public CompletableFuture<Response> modifyGroup(@Auth GroupUser user, @QueryParam(value="inviteLinkPassword") String inviteLinkPasswordString, @NoUnknownFields GroupChange.Actions submittedActions) {
        byte[] inviteLinkPassword = Strings.isNullOrEmpty((String)inviteLinkPasswordString) ? null : Base64.decodeBase64((String)inviteLinkPasswordString);
        return this.groupsManager.getGroup(user.getGroupId()).thenCompose(group -> {
            if (group.isEmpty()) {
                throw new BadRequestException("No such group exists");
            }
            if (((Group)group.get()).getVersion() >= submittedActions.getVersion() || ((Group)group.get()).getVersion() != submittedActions.getVersion() - 1) {
                return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.CONFLICT).entity(group.get()).build());
            }
            GroupChange.Actions actions = submittedActions.toBuilder().clearAddMembers().addAllAddMembers(this.groupValidator.validateAddMember(user, inviteLinkPassword, (Group)group.get(), submittedActions.getAddMembersList())).clearAddMembersPendingProfileKey().addAllAddMembersPendingProfileKey(this.groupValidator.validateAddMembersPendingProfileKey(user, (Group)group.get(), submittedActions.getAddMembersPendingProfileKeyList())).clearAddMembersPendingAdminApproval().addAllAddMembersPendingAdminApproval(this.groupValidator.validateAddMembersPendingAdminApproval(user, inviteLinkPassword, (Group)group.get(), submittedActions.getAddMembersPendingAdminApprovalList())).build();
            int changeEpoch = 0;
            Group.Builder modifiedGroupBuilder = ((Group)group.get()).toBuilder();
            this.groupChangeApplicator.applyAddMembers(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getAddMembersList());
            this.groupChangeApplicator.applyDeleteMembers(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getDeleteMembersList());
            this.groupChangeApplicator.applyModifyMemberRoles(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getModifyMemberRolesList());
            this.groupChangeApplicator.applyModifyMemberProfileKeys(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getModifyMemberProfileKeysList());
            this.groupChangeApplicator.applyAddMembersPendingProfileKey(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getAddMembersPendingProfileKeyList());
            this.groupChangeApplicator.applyDeleteMembersPendingProfileKey(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getDeleteMembersPendingProfileKeyList());
            this.groupChangeApplicator.applyPromoteMembersPendingProfileKey(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getPromoteMembersPendingProfileKeyList());
            if (actions.hasModifyTitle()) {
                this.groupChangeApplicator.applyModifyTitle(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getModifyTitle());
            }
            if (actions.hasModifyAvatar()) {
                this.groupChangeApplicator.applyModifyAvatar(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getModifyAvatar());
            }
            if (actions.hasModifyDisappearingMessageTimer()) {
                this.groupChangeApplicator.applyModifyDisappearingMessageTimer(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getModifyDisappearingMessageTimer());
            }
            if (actions.hasModifyAttributesAccess()) {
                this.groupChangeApplicator.applyModifyAttributesAccess(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getModifyAttributesAccess());
            }
            if (actions.hasModifyMemberAccess()) {
                this.groupChangeApplicator.applyModifyMembersAccess(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getModifyMemberAccess());
            }
            if (actions.hasModifyAddFromInviteLinkAccess()) {
                this.groupChangeApplicator.applyModifyAddFromInviteLinkAccess(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getModifyAddFromInviteLinkAccess());
                changeEpoch = Math.max(changeEpoch, 1);
            }
            if (actions.getAddMembersPendingAdminApprovalCount() != 0) {
                this.groupChangeApplicator.applyAddMembersPendingAdminApproval(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getAddMembersPendingAdminApprovalList());
                changeEpoch = Math.max(changeEpoch, 1);
            }
            if (actions.getDeleteMembersPendingAdminApprovalCount() != 0) {
                this.groupChangeApplicator.applyDeleteMembersPendingAdminApproval(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getDeleteMembersPendingAdminApprovalList());
                changeEpoch = Math.max(changeEpoch, 1);
            }
            if (actions.getPromoteMembersPendingAdminApprovalCount() != 0) {
                this.groupChangeApplicator.applyPromotePendingAdminApproval(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getPromoteMembersPendingAdminApprovalList());
                changeEpoch = Math.max(changeEpoch, 1);
            }
            if (actions.hasModifyInviteLinkPassword()) {
                this.groupChangeApplicator.applyModifyInviteLinkPassword(user, inviteLinkPassword, (Group)group.get(), modifiedGroupBuilder, actions.getModifyInviteLinkPassword());
                changeEpoch = Math.max(changeEpoch, 1);
            }
            ByteString sourceUuid = Stream.of(() -> GroupAuth.getMember(user, (Group)group.get()).map(Member::getUserId), () -> GroupAuth.getMember(user, modifiedGroupBuilder.build()).map(Member::getUserId), () -> GroupAuth.getMemberPendingProfileKey(user, (Group)group.get()).map(pending -> pending.getMember().getUserId()), () -> GroupAuth.getMemberPendingAdminApproval(user, (Group)group.get()).map(MemberPendingAdminApproval::getUserId), () -> GroupAuth.getMemberPendingAdminApproval(user, modifiedGroupBuilder.build()).map(MemberPendingAdminApproval::getUserId)).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(ForbiddenException::new);
            actions = actions.toBuilder().setSourceUuid(sourceUuid).build();
            byte[] serializedActions = actions.toByteArray();
            int version = actions.getVersion();
            NotarySignature signature = this.serverSecretParams.sign(serializedActions);
            GroupChange signedGroupChange = GroupChange.newBuilder().setActions(ByteString.copyFrom((byte[])serializedActions)).setServerSignature(ByteString.copyFrom((byte[])signature.serialize())).setChangeEpoch(changeEpoch).build();
            Group updatedGroupState = modifiedGroupBuilder.setVersion(version).build();
            this.groupValidator.validateFinalGroupState(updatedGroupState);
            return this.groupsManager.updateGroup(user.getGroupId(), updatedGroupState).thenCompose(result -> {
                if (result.isPresent()) {
                    return CompletableFuture.completedFuture(Response.status((Response.Status)Response.Status.CONFLICT).entity(result.get()).build());
                }
                return this.groupsManager.appendChangeRecord(user.getGroupId(), version, signedGroupChange, updatedGroupState).thenApply(success -> Response.ok((Object)signedGroupChange).build());
            });
        });
    }

    @Timed
    @GET
    @Produces(value={"application/x-protobuf"})
    @Path(value="/token")
    public CompletableFuture<Response> getToken(@Auth GroupUser user) {
        return this.groupsManager.getGroup(user.getGroupId()).thenApply(group -> {
            if (group.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Optional<Member> member = GroupAuth.getMember(user, (Group)group.get());
            if (member.isPresent()) {
                String token = this.externalGroupCredentialGenerator.generateFor(member.get().getUserId(), user.getGroupId());
                ExternalGroupCredential credential = ExternalGroupCredential.newBuilder().setToken(token).build();
                return Response.ok((Object)credential).build();
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        });
    }
}

