/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import org.signal.storageservice.StorageServiceConfiguration;

public enum Cassandra {
    DB;

    private Session session;
    private Cluster cluster;
    private static StorageServiceConfiguration config;

    public void connect() {
        if (this.session == null && this.cluster == null) {
            Cluster.Builder b = Cluster.builder().addContactPoint(config.getCassandra().getServer()).withCredentials(config.getCassandra().getUser(), config.getCassandra().getPwd()).withPoolingOptions(new PoolingOptions()).withReconnectionPolicy((ReconnectionPolicy)new ConstantReconnectionPolicy(100L));
            b.withPort(9042);
            this.cluster = b.build();
            this.session = this.cluster.connect(config.getCassandra().getCluster());
        }
    }

    public void shutdown() {
        if (null != this.session) {
            this.session.close();
        }
        if (null != this.cluster) {
            this.cluster.close();
        }
        System.out.println("Closing cassandra");
    }

    public Session getSession() {
        if (this.session == null) {
            this.connect();
        }
        return this.session;
    }

    public static void setConfig(StorageServiceConfiguration config1) {
        config = config1;
    }
}

